// **********************************
// *    JSpeccy Javascript Script   *
// *        (C) by F. Gerbig        *
// *           24.02.2017           *
// *                                *
// *            based on            *
// *  WinVICE Default GEMUS Script  *
// *        (c) The GB64 Team       *
// *          8 August 2007         *
// *             and on             *
// *           "vice.sh"            *
// *        (C) by F. Gerbig        *
// *            2006-2010           *
// **********************************
//
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
//
//  Emulator File: JSpeccy
//  Emulator configuration file:
//  File Types: csw;rom;sna;sp;szx;tap;tzx;z80
//
//  This script was written for JSpeccy v0.93,
//  but may work with other versions too.
//
//  Emulator Website: http://jspeccy.speccy.org

command = "java";
Add_CLP(command);

// The emulator path should be set via jGameBase (Emulators => Manage Game Emulators).
// There the path to this JavaScript file is specified and the JSpeccy.jar is expected to be in the same directory.
// If you need to adjust this path specify "true" instead of "false" and use the lines below:
if (false) {
	emulatorPath = ".." + separator + ".." + separator + "JSpeccy";
	println("");
	println("The script overwrites the emulatorPath:");
	println("  relative emulatorPath='" + emulatorPath + "'");
	emulatorPath = File(emulatorPath).getCanonicalPath(); // convert path to absolute
	println("  absolute emulatorPath='" + emulatorPath + "'");
	println("");
}

Add_CLP("-jar");

// is "-Dsun.java2d.opengl=True" still necessary?
// This may help with some ui issues related with Swing (enabling it may cause errors if opengl is not installed)
Add_CLP("-Dsun.java2d.opengl=True");

// save the JSpeccy.xml in the same folder as JSpeccy.jar
Add_CLP("-Duser.home=" + emulatorPath);

// call emulator
Add_CLP(emulatorPath + separator + "JSpeccy.jar");

// print all variables (remove for production)
Dump();

if (itemType.contains("sna", "z80", "szx", "sp", "tap", "tzx", "csw", "rom")) {

	// SET JOYSTICK
    var joystick="NONE";
	// guess joystick from itemControl
	if (itemControl === JOYPORT1) {
		joystick="SINCLAIR1";
	} else if (itemControl === JOYPORT2) {
		joystick="SINCLAIR2";
	}
    // if KEY=VALUE "JOYSTICK" was specified, use that:
    // JOYSTICK has to be one of "NONE", "KEMPSTON", "SINCLAIR1", "SINCLAIR2", "CURSOR", "FULLER".
    if (Value("JOYSTICK").contains("*")) { // value not empty
        joystick = Value("JOYSTICK");
    }
    Add_CLP("--joystick", joystick);

	// unsupported item controls
	if (itemControl === LIGHTPEN) {
		Show_Message("This emulator does not have LightPen emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === KOALAPAD) {
		Show_Message("This emulator does not have KoalaPad emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === LIGHTGUN) {
		Show_Message("This emulator does not have LightGun emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT1) {
		Show_Message("This emulator does not have Paddle emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT2) {
		Show_Message("This emulator does not have Paddle emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === MOUSE) {
		Show_Message("This emulator does not have Mouse emulation.\n\nThis item may be uncontrollable/unplayable.");
	}

	if (itemVersionComment.contains("*not 100%*", "*not working*", "*doesn't work*")) {
		Show_Message("This item may not work properly.");
	}
	if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
		// point out that critical info is in the version comment
		Show_Message("Read this item's Version Comments for very important information/instructions.");
	}

	// show message for the user
	if (Value("msg").contains("*")) {
		Show_Message(Value("msg"));
	}

    // SET MODEL
    var model="SP48K"; // default model is SP48K
    // guess model by hint "16K", "48K" or "128K" in item name
    if (itemName.contains("*128K*")) {
        model="SP128K";
    } else if (itemName.contains("*48K*")) {
        model="SP48K";
    } else if (itemName.contains("*16K*")) {
        model="SP16K";
    }
    // if KEY=VALUE "MODEL" was specified, use that:
    // MODEL has to be one of "SP16K", "SP48K", "SP128K", "PLUS2", "PLUS2A", "PLUS3".
    if (Value("MODEL").contains("*")) { // value not empty
        model = Value("MODEL");
    }
    Add_CLP("--model", model);

	// autostart or 'manual load' the item image
	if (itemVersionComment.contains("*load manually*")) {
		Show_Message("This program should be loaded manually.");
	} else {
		Add_CLP(itemPathAndFile);
	}


    // zoom
    Add_CLP("--zoom", "3"); // try "2" on small screens
    Add_CLP("--zoom-filter", "BILINEAL");

    // border
    Add_CLP("--border-size", "STANDARD");

    // sound
	Add_CLP("--hifi-sound");
	Add_CLP("--melodik");
	Add_CLP("--sound-mode", "ACB");


   // don't ask "are you sure?" on exit :-)
    Add_CLP("--no-confirm-actions");


	// run the emulator
	Run_Emulator();

} else {

	// invalid item file type
	Show_Message(NOT_SUPPORTED + "\n\nSupported types: CSW, ROM, SNA, SP, SZX, TAP, TZX, Z80");

}



